
Description: Memory management header with structures and constants
Language: header
Lines: 167

/*
 * SMACKTM Memory Management Header
 */

#ifndef MEMORY_H
#define MEMORY_H

#include <stdint.h>
#include <stddef.h>
#include <stdbool.h>

// Page flags
#define PAGE_PRESENT     0x001
#define PAGE_WRITABLE    0x002
#define PAGE_USER        0x004
#define PAGE_ACCESSED    0x020
#define PAGE_DIRTY       0x040

// Heap block structure
struct heap_block {
    size_t size;
    bool used;
    struct heap_block* next;
    struct heap_block* prev;
};

// Function prototypes
int mm_init(void);
uint32_t alloc_page(void);
void free_page(uint32_t addr);
void* kmalloc(size_t size);
void kfree(void* ptr);

#endif // MEMORY_H

================================================================================


### DRIVERS MODULE ###

