
Description: Primary boot loader - initializes system and loads kernel
Language: assembly
Lines: 485

; SMACKTM Kernel Boot Loader
; Primary boot sector code that initializes the system

[BITS 16]
[ORG 0x7C00]

start:
    ; Clear interrupts and set up segments
    cli
    xor ax, ax
    mov ds, ax
    mov es, ax
    mov ss, ax
    mov sp, 0x7C00
    
    ; Enable A20 line
    call enable_a20
    
    ; Load kernel from disk
    mov ah, 0x02          ; Read sectors function
    mov al, 32            ; Number of sectors to read
    mov ch, 0             ; Cylinder
    mov cl, 2             ; Starting sector
    mov dh, 0             ; Head
    mov dl, 0x80          ; Drive (first hard drive)
    mov bx, 0x1000        ; Buffer address
    int 0x13
    jc disk_error
    
    ; Switch to protected mode
    lgdt [gdt_descriptor]
    mov eax, cr0
    or eax, 1
    mov cr0, eax
    
    ; Jump to kernel
    jmp 0x08:protected_mode

enable_a20:
    ; Fast A20 gate enable
    in al, 0x92
    or al, 2
    out 0x92, al
    ret

disk_error:
    mov si, disk_error_msg
    call print_string
    hlt

protected_mode:
    ; Set up segments for protected mode
    mov ax, 0x10
    mov ds, ax
    mov es, ax
    mov fs, ax
    mov gs, ax
    mov ss, ax
    
    ; Jump to kernel main
    jmp 0x1000

; Global Descriptor Table
gdt_start:
    dd 0x0, 0x0                    ; Null descriptor
    
gdt_code:
    dw 0xFFFF                      ; Limit
    dw 0x0                         ; Base
    db 0x0                         ; Base
    db 10011010b                   ; Access byte
    db 11001111b                   ; Flags
    db 0x0                         ; Base
    
gdt_data:
    dw 0xFFFF                      ; Limit
    dw 0x0                         ; Base
    db 0x0                         ; Base
    db 10010010b                   ; Access byte
    db 11001111b                   ; Flags
    db 0x0                         ; Base
    
gdt_end:

gdt_descriptor:
    dw gdt_end - gdt_start - 1     ; Size
    dd gdt_start                   ; Offset

disk_error_msg db 'Disk read error!', 0

times 510-($-$$) db 0
dw 0xAA55                          ; Boot signature

================================================================================

